/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.inventory;

import java.util.ArrayList;
import net.minecraft.world.item.crafting.Ingredient;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public Ingredient toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        Ingredient stack;
        if (bukkit == null) {
            stack = Ingredient.f_43901_;
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = new Ingredient(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> new Ingredient.ItemValue(CraftItemStack.asNMSCopy(new ItemStack((Material)mat)))));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = new Ingredient(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> new Ingredient.ItemValue(CraftItemStack.asNMSCopy(mat))));
            stack.exact = true;
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + bukkit);
        }
        stack.m_43948_();
        if (requireNotEmpty && stack.f_43903_.length == 0) {
            throw new IllegalArgumentException("Recipe requires at least one non-air choice!");
        }
        return stack;
    }

    public static RecipeChoice toBukkit(Ingredient list) {
        list.m_43948_();
        if (list.f_43903_.length == 0) {
            return null;
        }
        if (list.exact) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.f_43903_.length);
            for (net.minecraft.world.item.ItemStack i : list.f_43903_) {
                choices.add(CraftItemStack.asBukkitCopy(i));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        ArrayList<Material> choices = new ArrayList<Material>(list.f_43903_.length);
        for (net.minecraft.world.item.ItemStack i : list.f_43903_) {
            choices.add(CraftMagicNumbers.getMaterial(i.m_41720_()));
        }
        return new RecipeChoice.MaterialChoice(choices);
    }
}

